// משתנה לשמירת הכותרת האחרונה שנשלחה כדי למנוע הצפות
let lastSentTitle = "";

// פונקציה ששולחת עדכון ל-background
function notifyTitleUpdate() {
  const title = document.title;
  
  // סינון כותרות גנריות שלא מעניינות אותנו
  if (title === "Gemini" || title.includes("New Chat") || title.length < 2) {
    return;
  }

  if (title !== lastSentTitle) {
    lastSentTitle = title;
    chrome.runtime.sendMessage({
      action: "updateChatTitle",
      url: window.location.href,
      title: title
    });
  }
}

// 1. האזנה לשינויים ב-DOM של ה-Title (הדרך הכי מהירה לתפוס שינוי)
const titleObserver = new MutationObserver(() => {
  notifyTitleUpdate();
});

const titleElement = document.querySelector('title');
if (titleElement) {
  titleObserver.observe(titleElement, { childList: true });
}

// 2. בדיקה ראשונית בטעינה
notifyTitleUpdate();

// 3. האזנה לשינויי URL בתוך האפליקציה (SPA navigation)
let lastUrl = location.href; 
new MutationObserver(() => {
  const url = location.href;
  if (url !== lastUrl) {
    lastUrl = url;
    lastSentTitle = ""; // איפוס כדי לאפשר שמירה של דף חדש
    // מחכים טיפה שהכותרת תתעדכן בשיחה החדשה
    setTimeout(notifyTitleUpdate, 1000); 
  }
}).observe(document, {subtree: true, childList: true});